/*
  Zeichnet Linien in Mode 13                                    von XxX
  Public Domain
*/

#include <stdlib.h>
                        //fr about, rand, randomize
#include <bios.h>
                        //fr bioskey
void mode(unsigned int nr);          // Bildschirmmodus setzen
void pixel(int pos,int col);         // Zeichnet Pixel in Mode 13h

void main(void){

unsigned int D_P2=0;                 //Strecke D~P2
unsigned int A_B=0;                  //Strecke A~B

unsigned int Y_Pos_P1=0;             // Y_Position des ersten Punktes
unsigned int X_Pos_P1=0;             // X_Position des ersten Punktes

unsigned int Y_Pos_P2=0;             // Y_Position des zweiten Punktes
unsigned int X_Pos_P2=0;             // X_Position des zweiten Punktes

unsigned int Y_Pos_P_d=0;            // Y_Position des zu berechnenden Punktes
unsigned int X_Pos_P_d=0;            // X_Position des zu berechnenden Punktes
unsigned int col=0;                  // Farbe der zu zeichnenden Linie

randomize();                         // Zufallsgenarator initialisieren

mode(0x13);                          // springe in Mode 13h

while(bioskey(1)==0){                // solange durchlaufen bis Tastendruck

Y_Pos_P1=rand()%200;                 //zufllige Werte fr P1, P2 und Farbe
X_Pos_P1=rand()%320;                 //whlen
Y_Pos_P2=rand()%200;
X_Pos_P2=rand()%320;
col=rand()%256;

// Wenn ein Punkt auerhalb des Bildschirms==> abbrechen mit Fehlercode
if (X_Pos_P1>=320||X_Pos_P1>=320||Y_Pos_P1>=200||Y_Pos_P2>=200){
   mode(0x3);                        // Textmodus
   abort();}                         //Beenden des Programms

if(X_Pos_P1<X_Pos_P2){               //bentigte Formel whlen
  A_B = X_Pos_P2-X_Pos_P1;           //Strecke A~B berechnen

  if(Y_Pos_P1<Y_Pos_P2){             //bentigte Formel auswhlen
    D_P2 = Y_Pos_P2-Y_Pos_P1;        //Strecke D~P2 berechnen
    //Punkt berechnen und schreiben
    for ( X_Pos_P_d = X_Pos_P1 ; X_Pos_P_d  != X_Pos_P2; X_Pos_P_d++){
      Y_Pos_P_d     = (((X_Pos_P_d-X_Pos_P1) * D_P2) / A_B) +  Y_Pos_P1;
      pixel((320*Y_Pos_P_d)+X_Pos_P_d,col);     //Zeichnet Pixel
    }
  }

  else{
   D_P2 = Y_Pos_P1-Y_Pos_P2;
   //Punkt berechnen und schreiben
   for ( X_Pos_P_d = X_Pos_P1 ; X_Pos_P_d  != X_Pos_P2; X_Pos_P_d++){
      Y_Pos_P_d     = (((X_Pos_P2-X_Pos_P_d) * D_P2) / A_B) +  Y_Pos_P2;
      pixel((320*Y_Pos_P_d)+X_Pos_P_d,col);     //Zeichnet Pixel
   }
  }
}
else{

if(X_Pos_P1>=X_Pos_P2){
  A_B = X_Pos_P1-X_Pos_P2;
  if(Y_Pos_P1>Y_Pos_P2){                //bentigte Formel whlen
   D_P2 = Y_Pos_P1-Y_Pos_P2;            //Strecke D~P2 berechnen
   //Punkt berechnen und schreiben
   for ( X_Pos_P_d = X_Pos_P2 ; X_Pos_P_d  != X_Pos_P1; X_Pos_P_d++){
      Y_Pos_P_d     = (((X_Pos_P_d- X_Pos_P2)  * D_P2) / A_B) + Y_Pos_P2;
      pixel((320*Y_Pos_P_d)+X_Pos_P_d,col);  //Punkt zeichnen
           }
  }
  else{
      D_P2 = Y_Pos_P2-Y_Pos_P1;        //Strecke D~P2 berechnen
      //Punkt berechnen und schreiben
      for ( X_Pos_P_d = X_Pos_P2 ; X_Pos_P_d  != X_Pos_P1; X_Pos_P_d++){
       Y_Pos_P_d     = (((X_Pos_P1- X_Pos_P_d)  * D_P2) / A_B) + Y_Pos_P1;
       pixel((320*Y_Pos_P_d)+X_Pos_P_d,col);  //Punkt zeichnen
      }
  }}
}

}

mode(0x3);                              // Textmodus

}
/////////////////////////////////////////////////////////////////////////////
//////////////////////////////// Funktionen /////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

// Zeichnet Pixel
void pixel(int pos,int col){
asm {                           //Schreibe Punkt
    mov ax,0a000h
    mov es,ax
    mov bx,word ptr pos
    mov ax,word ptr col
    xor ah,ah
    mov es:[bx],al
    }
}

// Bildschirmmodus setzen
void mode(unsigned int nr)
{
  asm {
    mov ax,nr
    int 0x10
  }
}
