;#############################################################################
;#
;# VESA.ASM
;#
;# Purpose:
;#	Diverse vesa-funksjoner
;#
;#############################################################################

		.386
		Ideal
		Jumps
		Model Tiny,C
		CodeSeg

;******************************************************************************
;*
;* bool VesaInit( VersionRequired:WORD )
;*
;* Purpose:
;* 	Init Vesa
;*
;* Returns:
;*	true/false
;*
;******************************************************************************
Public		VesaInit
Proc		VesaInit	Uses es di
		arg VersionRequired:Word
		mov	ax,4F00h		; Get SVGA Info
		push	ds
		pop	es
		mov	di,offset VesaInfo
		int	10h
		call	VesaStandardCheck
		test	ax,ax
		jz	SHORT @@Failed
		mov	di,[VesaVersion]
		cmp	di,[VersionRequired]
		jb	SHORT @@Failed
		jmp	SHORT @@Exit
@@Failed:
		xor	ax,ax
@@Exit:
		ret
Endp

;******************************************************************************
;*
;* bool VesaSetMode( Mode:Word )
;*
;* Purpose:
;* 	Sets a vesa mode
;*
;* Arguments:
;*	Mode - the mode to set
;*
;* Returns:
;*	true/false
;*
;******************************************************************************
Public		VesaSetMode
Proc		VesaSetMode	Uses bx cx es di
		arg Mode:Word

IFNDEF FIXED_VIDEOWIDTH
		mov	ax,4F01h		; Get VESA mode info
		mov	cx,[Mode]
		mov	di,seg VesaModeInfo
		mov	es,di
		mov	di,offset VesaModeInfo
		int 	10h
		call	VesaStandardCheck
		test	ax,ax
		jz	SHORT @@Exit
@@ModeOk:
		xor	bx,bx
		mov	bl,[BitsPerPixel]
		shr	bx,3			; Get bytes per pixel
		mov	[VesaModeBytesPerPixel],bx

		mov	ax,[WidthInPixels]
		mov	[VesaModeBytesPerPixel],ax
		mul	bx
		mov	[VesaModeWidthInBytes],ax
ENDIF

 		;mov	ax,[HeightInPixels]
 		;mov	[VesaModeHeightInPixels],ax
 		;mul	bx
 		;mov	[VesaModeHeightInBytes],ax
		xor	dx,dx

		mov	ax,4F02h		; Set VESA video mode
		mov	bx,[Mode]
		int	10h
		call	VesaStandardCheck
@@Exit:
		ret
Endp

;******************************************************************************
;*
;* bool VesaSetBank( Bank:Word )
;*
;* Purpose:
;*	Sets the vesa-bank
;*
;* Arguments:
;*	Bank - the bank to set
;*
;* Returns:
;*	true/false
;*
;******************************************************************************
Public		VesaSetBank
Proc		VesaSetBank	Uses bx dx
		arg	Bank:Word
		mov	ax,4F05h		; Set/get bank
		mov	dx,[Bank]		; Bank #
		mov	bx,0			; Set window A
		int	10h
		call	VesaStandardCheck
		ret
Endp

;******************************************************************************
;*
;* bool VesaStandardCheck()
;*
;* Purpose:
;*	General function to check if a vesa-call was successful
;*
;* Returns:
;*	true/false
;*
;******************************************************************************
Proc		VesaStandardCheck
		cmp	al,4Fh
		jne	Short @@UnSuccessful
		test	ah,ah
		jz	Short @@Successful
@@UnSuccessful:
		xor	ax,ax
		jmp	SHORT @@Exit
@@Successful:
		mov	ax,1
@@Exit:
		ret
Endp		VesaStandardCheck

Public		VesaSetDisplayStart
Proc		VesaSetDisplayStart	uses eax ebx ecx edx
		arg	start:dword

		; Get start line and start row
		mov	eax,[start]
		mov	cx,[BytesPerScanLine]
		xor	ecx,ecx
		mov	cx,[BytesPerScanLine]
		xor	edx,edx
		div	ecx			; start/bytesperscanline
		; Line in eax,row in edx
		mov     cx,dx
		mov	dx,ax
		mov	ax,4F07h
		xor	bx,bx
		int	10h
		ret
Endp		VesaSetDisplayStart

		DataSeg
		Align 2
;public VesaModeWidthInPixels
;VesaModeWidthInPixels	dw	0
;public VesaModeHeightInPixels
;VesaModeHeightInPixels	dw	0
IFNDEF FIXED_VIDEOWIDTH
public VesaModeBytesPerPixel
VesaModeBytesPerPixel	dw	0
public VesaModeWidthInBytes
VesaModeWidthInBytes	dw	0
ENDIF
;public VesaModeHeightInBytes
;VesaModeHeightInBytes	dw	0

Label VesaInfo
Signature	db	4 dup(0)
VesaVersion	dw	0
OEMName		dd	0
Capabilities	db	4 dup(0)
SupportedModes	dd	0
VideoMemory	dw	0
Reserved	db	236 dup(0)

Label VesaModeInfo
ModeAttribs	dw	0
WindowAAttribs	db	0
WindowBAttribs	db	0
WindowGranlularity dw	0
WindowSize	dw	0
WindowAStartSeg	dw	0
WindowBStartSeg	dw	0
WindowPosFunc	dd	0
BytesPerScanLine dw	0
WidthInPixels	dw	0
HeightInPixels	dw	0
WidthCharCel	db	0
HeightCharCel	db	0
MemPlanes	db	0
BitsPerPixel	db	0
Banks		db	0
MemoryModelType	db	0
SizeOfBank	db	0
ImagesPages	db	0
Reserved_1	db	0
; Vesa 1.2
RedMaskSize	db	0
RedMaskPosition	db	0
GreenMaskSize	db	0
GreenMaskPosition db	0
BlueMaskSize	db	0
BlueMaskPosition db	0
ReservedMaskSize db	0
ReservedMaskPosition db	0
DirectScreenModeInfo db 0
Reserved_2	db	0
; Vesa 2.0
Misc_1		db	256 dup(0)		; Trengs denne?
		db	1024 dup(0)		; Sikkerhet


		End
