; 
; 


 LOCALS		; enable '@@' local labels

.MODEL SMALL,C
.STACK 1024
.DATA
mypicname	db	'hugipic.pcx',0	; <-- ASCII-Z filename

.CODE
.386

; 
;
; Loads a 320x200 pixel 256 colour PCX picture at 'pcxseg:0000' address
;
; NOTE:	The 768 byte palette is loaded at offset 64000 from pcxseg segment.
;	so make sure you allocate 64768 bytes (0FD00 hex) for each PCX.
;
;	Your PCX picture MUST be 320x200 pixels and 256 colours !!!!
;
; E.g.
;     	call LoadPCX C, ds picname, 0A000h
;
;	will load PCX at A000:0000 hex	(image A000:0000 to A000:F9FF hex)
;				      (palette A000:FA00 to A000:FCFF hex)
; 

LoadPCX proc near
 arg pcxfname:dword, pcxseg:word

 push ds
 push es		; save DS and ES
 pusha			; save all registers

 lds dx,[pcxfname]	; [DS:DX] --> filename
 mov ax,3D00h
 int 21h		; open file
 jc short @@lderr	; error ?
 mov bx,ax		; BX = file handle

 ;; first skip 128-byte header ;; 

 sub cx, cx
 mov dx, 128
 mov ax,4200h
 int 21h

 ;; now read & depack PCX image (320x200x256 colours)

 mov es,[pcxseg]
 sub di,di		; [ES:DI] --> where to depack 
 mov dx,64000		; 64000 bytes to depack
@@depack:
 call readfilebyte	; n = readbyte()
 jc short @@lderr
 mov cx,1		; CX = 1 (repeat count)
 cmp al,0C0h
 jbe short @@raw1	; n = 00 to BFh ?
 sub al,0C0h
 mov cl,al		; else CX = n - C0h
 call readfilebyte	;      n = readbyte()
 jc short @@lderr

@@raw1:
 sub dx,cx
 jc short @@lderr	; output buffer overflow ?
 rep stosb		; else repeat the pixel AL
 jnz short @@depack	; repeat until DX=0000

 ;; now read & convert the palette ;;

 mov cx,-1
 mov dx,-768
 mov ax,4202h
 int 21h   		; seek EOF - 768 bytes

 push es
 pop ds
 mov dx,di		; [DS:DX] --> after image
 mov cx,768
 mov ah,3Fh
 int 21h		; read 768 bytes
 jc short @@lderr

@@rgblp:
 shr byte ptr ds:[di],2	; divide all the RGB values by 4
 inc di
 loop @@rgblp

 clc
@@lderr:
 popa
 pop es
 pop ds			; restore DS and ES
 ret
LoadPCX endp

;
; This read a byte from opened file(BX) into(AX) register.
;
readfilebyte proc
 push cx
 push dx
 push ds
 push ax	; <--- the byte will be read into this word on the stack
 mov ax,ss
 mov ds,ax
 mov dx,sp
 mov cx,1
 mov ah,3Fh
 int 21h
 jc short @@1
 sub ax,cx	; produce CF=1 for EOF (ie. AX=0000 after load)
@@1:
 pop ax
 pop ds
 pop dx
 pop cx
 ret
readfilebyte endp

; 
; Set the VGA palette (768 bytes = 256 x R,G,B values)
; 

SetPalette proc near
 arg paltaddr:dword

 pusha
 push ds
 mov dx,3C8h
 mov al,0		; write palette starting at colour 00
 out dx,al
 inc dx

 lds si, [paltaddr]	; [DS:SI] --> palette (768 bytes)
 mov cx, 768
@@1:
 lodsb
 out dx,al
 loop @@1
 pop ds
 popa
 ret
SetPalette endp

; 
; Initialise the palette index 0..F for colours 0..F
; 
InitPalette proc
	pusha
	mov	bx,0Fh
@@1:
	push	bx	
	mov	bh,bl
	mov	ax,1000h
	int	10h
	pop	bx
	dec	bx
	jns	short @@1
	popa
	ret
InitPalette endp


; 

start:
 mov ax,@data
 mov ds,ax

 mov ax,0013h
 int 10h		; mode 320x200 256 colours

 call InitPalette

 call LoadPCX C, ds offset mypicname, 0A000h
 jc quit		; load error ?

 call SetPalette C, 0A000h 64000

 mov ah,0
 int 16h		; read/wait for key press

quit:
 mov ax,0003h	
 int 10h		; back to text mode 3

 mov ax,4C00h
 int 21h		; quit..

 end	start
