{ Appendix for Hacker #4 diskmag }
{ Example of .3DS files reading  }
{ by Street Raider // DDT Ent.   }

{$A+,B-,D+,E+,F-,G+,I+,L+,N+,O-,P-,Q-,R-,S+,T-,V+,X+,Y+}

program Read3DS;

type
  PLongInt = ^LongInt;
  PWord = ^Word;
  PInt = ^Integer;
  PSingle = ^Single;
  PArray = ^TArray;
  TArray = array [0..0] of Byte;
  TPrefix = String[12];
  THex = String[8];
  TPoint = record X, Y, Z: Single; end;

var
  Block: PArray;
  Size: Word;
  F: File;

function Hex(Value: LongInt; Len: Integer): THex;
const
  HexChars: array [0..$F] of Char = '0123456789ABCDEF';
var
  Result: THex;
  I: Byte;
begin
  Result := '';
  For I := 1 to Len do
  begin
    Result := HexChars[Value and $0F] + Result;
    Value := Value shr 4;
  end;
  Hex := Result;
end;

procedure DisplayChunks(Start, Size: Word; Prefix: TPrefix);

var
  P, iD, Ptr: Word;
  Len, SubLen: LongInt;
  C: Char;

procedure DumpB020(Block: Pointer; Size: Word);
type
  PFloatArray = ^TFloatArray;
  TFloatArray = record
    Unknown1: array [0..7] of Byte;
    Count: LongInt;
    Data: array [1..1] of record
      Frame: LongInt;
      Unknown2: Word;
      P: TPoint;
    end;
  end;
var
  I: Integer;
begin
  with PFloatArray(Block)^ do
    For I := 1 to Count do
      with Data[I] do
        WriteLn(Prefix, ' Frame ', Frame:2, ': [', P.X:7:2, ',', P.Y:7:2, ',', P.Z:7:2, '], ?=', Hex(Unknown2, 4));
end;

procedure DumpB023(Block: Pointer; Size: Word; NAme: PChar);
type
  PFloatArray = ^TFloatArray;
  TFloatArray = record
    Unknown1: array [0..7] of Byte;
    Count: LongInt;
    Data: array [1..1] of record
      Frame: LongInt;
      Unknown2: Word;
      Roll: Single;
    end;
  end;
var
  I: Integer;
begin
  with PFloatArray(Block)^ do
    For I := 1 to Count do
      with Data[I] do
        WriteLn(Prefix, ' Frame ', Frame:2, ': ', Name, ' = ', Roll:7:2, ', ?=', Hex(Unknown2, 4));
end;

procedure DumpLight(Block: Pointer);
type
  PLight = ^TLight;
  TLight = record
    P: TPoint;
  end;
begin
  with PLight(Block)^ do WriteLn(Prefix, ' Light at [', P.X:7:2, ',', P.Y:7:2, ',', P.Z:7:2, ']');
  DisplayChunks(Start + P + 6 + SizeOf(TLight), Len - 6 - SizeOf(TLight), Prefix + ' ');
end;

procedure DumpColor(Block: Pointer);
type
  PColor = ^TColor;
  TColor = record
    R, G, B: Single;
  end;
begin
  with PColor(Block)^ do WriteLn(Prefix, ' Color: R:', R:0:2, ' G:', G:0:2, ' N:', B:0:2);
end;

procedure Dump24bitColor(Block: Pointer);
type
  PColor = ^TColor;
  TColor = record
    R, G, B: Byte;
  end;
begin
  with PColor(Block)^ do WriteLn(Prefix, ' Color: R:', R, ' G:', G, ' N:', B);
end;

procedure DumpCamera(Block: Pointer);
type
  PCamera = ^TCamera;
  TCamera = record
    Pos, Target: TPoint;
    Roll, Lens: Single;
  end;
begin
  with PCamera(Block)^ do
  begin
    WriteLn(Prefix, ' Camera position: [', Pos.X:7:2, ',', Pos.Y:7:2, ',', Pos.Z:7:2, ']');
    WriteLn(Prefix, ' Camera target  : [', Target.X:7:2, ',', Target.Y:7:2, ',', Target.Z:7:2, ']');
    WriteLn(Prefix, ' Roll: ', Roll:0:2, ', Lens: ', Lens:0:2);
  end;
end;

procedure DumpSpotLight(Block: Pointer);
type
  PSpotLight = ^TSpotLight;
  TSpotLight = record
    Target: TPoint;
    HotSpot, Falloff: Single;
  end;
begin
  with PSpotLight(Block)^ do
  begin
    WriteLn(Prefix, ' Light target  : [', Target.X:7:2, ',', Target.Y:7:2, ',', Target.Z:7:2, ']');
    WriteLn(Prefix, ' HotSpot: ', HotSpot:0:2, ', Falloff: ', Falloff:0:2);
  end;
end;

procedure DumpTransMatrix(Block: Pointer);
type
  PTransMatrix = ^TTransMatrix;
  TTransMatrix = record M: array [1..4, 1..3] of Single; end;
var
  I: Integer;
begin
  with PTransMatrix(Block)^ do
    For I := 1 to 4 do
    begin
      WriteLn(Prefix, ' [', M[I, 1]:7:2, ',', M[I, 2]:7:2, ',', M[I, 3]:7:2, ']');
    end;
end;

function Info: PChar;
begin
  case iD of
    $3D3D: Info := '3D Editor main chunk';
    $B000: Info := 'KeyFramer main chunk';
    $4600: Info := 'Light';
    $3000: Info := 'Default view';
    $4610: Info := 'Spot Light';
    $0010: Info := 'RGB color';
    $0011: Info := 'RGB color (24 bit)';
    $1300: Info := 'Gradient background 8-()';
    $1100: Info := 'BackGround bitmap';
    $2100: Info := 'Ambient color';
    $4700: Info := 'Camera';
    $4000: Info := 'Object block';
    $4100: Info := 'Triangular polygon object';
    $4110: Info := 'Vertex list';
    $4120: Info := 'Faces list';
    $4160: Info := 'Translation matrix';
    $B008: Info := 'Frames';
    $B009: Info := 'Current frame';
    $B013: Info := 'Object pivot point 8-()';
    $B014: Info := 'Bounding box 8-()';
    $B020: Info := 'Position keys';
    $B021: Info := 'Rotation keys';
    $B022: Info := 'Scaling keys';
    $B023: Info := 'FOV keys';
    $B024: Info := 'Roll keys';
    $B026: Info := 'Morph keys?';
    $B010: Info := 'Name and hierarchy';
    $B011: Info := 'Dummy object';
    $B001: Info := 'Ambient light';
    $B002: Info := 'Object info';
    $B003: Info := 'Camera origin';
    $B004: Info := 'Camera target';
    $B005: Info := 'Omni light';
    $B006: Info := 'Light target';
    $B007: Info := 'Light origin';
    $B030, $7001: Info := 'Unknown';
    else Info := '???';
  end;
end;

procedure WriteASCIIZ(Title: PChar; Delta: Integer);
begin
  Write(Prefix, ' ', Title, ': ');
  SubLen := Len - 6;
  Ptr := Start + P + 6 + Delta;
  repeat
    C := Char(Block^[Ptr]);
    Inc(Ptr); Dec(SubLen);
    if C = #0 then Break;
    Write(C);
  until False;
  WriteLn;
end;

begin
  P := 0;
  while P < Size do
  begin
    Move(Block^[Start + P], iD, 2);
    Move(Block^[Start + P + 2], Len, 4);
    WriteLn(Prefix, Hex(iD, 4), ' at ', Hex(Start + P, 4), ': ', Len - 6, ' bytes - ', Info);
    case iD of
      $4D4D, $3D3D, $4100, $B000..$B007, $2100, $1200:
        DisplayChunks(Start + P + 6, Len - 6, Prefix + ' ');
      $7001:
        DisplayChunks(Start + P + $14, Len - $14, Prefix + ' ');
      $4000:
        begin
          WriteASCIIZ('Object', 0);
          DisplayChunks(Ptr, SubLen, Prefix + ' ');
        end;
      $B020:
        DumpB020(@Block^[Start + P + 6 + 2], Len - 6);
      $B023:
        DumpB023(@Block^[Start + P + 6 + 2], Len - 6, 'FOV');
      $B024:
        DumpB023(@Block^[Start + P + 6 + 2], Len - 6, 'Roll');
      $B010:
        begin
          WriteASCIIZ('Object', 0);
          WriteLn(Prefix, ' Hierarchy: ', PInt(@Block^[Ptr + 4])^);
        end;
      $B008:
        WriteLn(Prefix, ' Frames: ', PLongInt(@Block^[Start + P + 6])^, '..', PLongInt(@Block^[Start + P + 6 + 4])^);
      $4600:
        DumpLight(@Block^[Start + P + 6]);
      $0010:
        DumpColor(@Block^[Start + P + 6]);
      $0011:
        Dump24bitColor(@Block^[Start + P + 6]);
      $4700:
        DumpCamera(@Block^[Start + P + 6]);
      $4610:
        DumpSpotLight(@Block^[Start + P + 6]);
      $1100:
        WriteASCIIZ('Background bitmap', 0);
      $4160:
        DumpTransMatrix(@Block^[Start + P + 6]);
      $3000:
        begin
          if Block^[Start + P + 6] = $80 then
            WriteASCIIZ('Default view', 6)
          else
            WriteLn(Prefix, ' Default view is not a camera :(');
        end;
    end;
    Inc(P, Len);
  end;
end;

begin
  WriteLn('-x-');
  FileMode := 0;
  Assign(F, ParamStr(1))
  Reset(F, 1);
  Size := FileSize(F);
  GetMem(Block, Size);
  BlockRead(F, Block^, Size);
  Close(F);
  DisplayChunks(0, Size, '');
  FreeMem(Block, Size);
end.
